Texture g_Tex;
sampler2D s = sampler_state {
	Texture = <g_Tex>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = NONE;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

float4 Boundary = {-1.6, -1.2, 1.6, 1.2};
float2 C = {0.325, 0.417};

float4 fJulia ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	// Get current position
	float2 Cpos = float2(lerp(Boundary.x, Boundary.z, texCoords.x), lerp(Boundary.y, Boundary.w, texCoords.y));

	// Start with black color
	float4 Out = {0.0, 0.0, 0.0, 1.0};

	for (int i = 0; i < 40; i++)
	{
		// Formula
		Cpos = float2((Cpos.x*Cpos.x) - (Cpos.y*Cpos.y), 2*Cpos.x*Cpos.y) + C;

		// Without [flatten] we get a compile error
		// I'm not 100% sure, but I think it has something to do with tex2D() being used.
		[flatten] if(length(Cpos) > 2.0) {
			Out = tex2D(s, float2(i / 40.0, 0.5));
			i = 1000;
		}
	}
	return Out;
}

float4 fMandelbrot ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	// the same as Julia, but slightly different formula
	float2 Cri = float2(lerp(Boundary.x, Boundary.z, texCoords.x), lerp(Boundary.y, Boundary.w, texCoords.y));
	float2 Cpos = float2(0.0, 0.0);
	float4 Out = {0.0, 0.0, 0.0, 1.0};

	for (int i = 0; i < 40; i++)
	{
		Cpos = float2((Cpos.x*Cpos.x) - (Cpos.y*Cpos.y), 2*Cpos.x*Cpos.y) + Cri;
		[flatten] if(length(Cpos) > 2.0)
		{
			Out = tex2D(s, float2(i / 40.0, 0.5));
			i = 1000;
		}
	}
	return Out;
}

technique Julia
{
	pass p0
	{
		PixelShader = compile ps_3_0 fJulia();
	}
}

technique Mandelbrot
{
	pass p0
	{
		PixelShader = compile ps_3_0 fMandelbrot();
	}
}